<?php

namespace App\Http\Controllers\Auth;

use App\User;
use App\Http\Controllers\Controller;
use Socialite;
use Exception;
use Auth;
use Mail;

use Illuminate\Support\Facades\Hash;

class GoogleController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function redirectToGoogle()
    {
        return Socialite::driver('google')->redirect();
    }
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function handleGoogleCallback()
    {
        try {
            $user = Socialite::driver('google')->user();
            $create['name'] = $user->getName();
            $create['email'] = $user->getEmail();

            $userModel = new User;
            $createdUser = $userModel->firstOrCreate($create, ['google_id' => $user->getId(), 'password' => Hash::make("admin123")]);

            Auth::loginUsingId($createdUser->id);

            $to_name = $create['name'];
            $to_email = $create['email'];
            $password = 'admin123';
            $data = array('name'=>$to_name, "body" => "Welcome Mail");
            Mail::send(['name' => $to_name], $data, function ($message) use ($to_name, $to_email, $password) {
                $message->from('ryansians@gmail.com', 'Socialize login');
                $message->attach('Your temporary password: '.$password);
                $message->to($to_email)->subject('Notification email from Socialize login');
            });
            /*if (Mail::failures()) {
                dd("Mail sending failed");
            }*/

            return redirect()->route('home');
        } catch (Exception $e) {
            dd($e);
            return redirect('auth/google');
        }
    }
}